package com.bokesoft.yigo.meta.common;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaScriptCollection extends GenericKeyCollection<MetaScript> {
	private MetaScript save = null;
	private MetaScript load = null;
	private MetaScript show = null;
	public MetaScriptCollection() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
	}
	
	public static final String TAG_NAME = "ScriptCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaScript.TAG_NAME.equals(tagName) ) {
			MetaScript metaScript = new MetaScript();
			metaScript.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaScript);
			resultMetaObject = metaScript;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaScriptCollection();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaScriptCollection newScriptCollection = (MetaScriptCollection) super.clone();
		newScriptCollection.setSave(save == null ? null : (MetaScript) save.clone());
		newScriptCollection.setLoad(load == null ? null : (MetaScript) load.clone());
		newScriptCollection.setShow(show == null ? null : (MetaScript) show.clone());
		return newScriptCollection;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		this.load = null;
		this.save = null;
		Iterator<MetaScript> it = this.iterator();
		MetaScript metaScript = null;
		while ( it.hasNext() ) {
			metaScript = it.next();
			if ( metaScript.getVerb() == FormVerb.Load ) {
				load = metaScript;
			} else if ( metaScript.getVerb() == FormVerb.Save ) {
				save = metaScript;
			} else if ( metaScript.getVerb() == FormVerb.Show ) {
				show = metaScript;
			}
		}
	}

	public MetaScript getSave() {
		return save;
	}
	
	public void setSave(MetaScript save) {
		this.save = save;
	}
	
	public MetaScript getLoad() {
		return load;
	}
	
	public void setLoad(MetaScript load) {
		this.load = load;
	}
	
	public MetaScript getShow() {
		return show;
	}
	
	public void setShow(MetaScript show) {
		this.show = show;
	}
}
