package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.FormVerb;
import com.bokesoft.yigo.common.def.ScriptRange;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaScript extends MetaBaseScript {
	private String key = "";
	private String caption = "";
	private String description = "";
	private Integer range = ScriptRange.All;
	private Integer verb = FormVerb.Other;
	public MetaScript() {
		super(TAG_NAME);
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "Script";

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaScript newObject = (MetaScript)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDescription(description);
		newObject.setRange(range);
		newObject.setVerb(verb);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaScript();
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getCaption() {
		return this.caption;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return this.description;
	}

	public void setRange(Integer range) {
		this.range = range;
	}

	public Integer getRange() {
		return this.range;
	}

	public void setVerb(Integer verb) {
		this.verb = verb;
	}

	public Integer getVerb() {
		return this.verb;
	}

	@Override
	public boolean needCheckExtend() {
		return true;
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}
	
	@Override
	public void merge(MetaBaseScript script) {
		super.merge(script);
		MetaScript metaScript = (MetaScript)script;
		if(this.caption == null) {
			this.caption = metaScript.caption;
		}
		if(this.description == null) {
			this.description = metaScript.description;
		}
		if(this.range == -1) {
			this.range = metaScript.range;
		}
		if(this.verb == -1) {
			this.verb = metaScript.verb;
		}
	}
}
