package com.bokesoft.yigo.meta.checker;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 * 数据元素key校验， MetaDataElementCollection的add方法中也有相关校验，区别在于一个是集合和集合比较一个是单个key校验
 * 最好的方式，2块可以合并，目前没想好怎么处理
 */
public class MetaDataElementKeyChecker implements IMetaSolutionChecker {
	
	public void doCheck(IMetaFactory factory, String solutionKey) throws Throwable{
		if(solutionKey == null || solutionKey.isEmpty()) {
			return;
		}
		
		MetaDataElementDef primaryDataElementDef = factory.getDataElementDef("");
		if(primaryDataElementDef == null || primaryDataElementDef.getDataElementCollection() == null) {
			return;
		}
		
		MetaDataElementDef dataElementDef = factory.getDataElementDef(solutionKey);
		if(dataElementDef == null || dataElementDef.getDataElementCollection() == null) {
			return;
		}
		
		Set<String> set1 = primaryDataElementDef.getDataElementCollection().keySet();
		Set<String> set2 = dataElementDef.getDataElementCollection().keySet();
		
		Set<String> lowerCaseSet1 = new HashSet<>();
		Set<String> lowerCaseSet2 = new HashSet<>();
		
		for(String s: set1) {
			lowerCaseSet1.add(s.toLowerCase());
		}
		
		for(String s: set2) {
			lowerCaseSet2.add(s.toLowerCase());
		}
		
		Set<String> intersection = new TreeSet<>();		
		intersection.addAll(lowerCaseSet1);
		intersection.retainAll(lowerCaseSet2);
		if(!intersection.isEmpty()) {
			String s = intersection.stream().collect(Collectors.joining(","));
			throw new MetaException(MetaException.REPEAT_KEY_DEFINED,  SimpleStringFormat
					.format(StringTable.getString(null, "", StringTable.RepeatKeyDefined), s));
		}
	}

}
