package com.bokesoft.yigo.meta.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaChargingRuleCollection定义计费规则集合
 * @author wangyh
 *
 */
public class MetaChargingRuleCollection extends GenericCompositeCollection {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 描述 */
	private String description = "";
	/** 条件 */
	private MetaChargingRuleCondition condition = null;
	
	public MetaChargingRuleCollection() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "ChargingRuleCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaChargingRule.TAG_NAME.equals(tagName) ) {
			MetaChargingRule rule = new MetaChargingRule();
			this.add(rule);
			resultMetaObject = rule;
		} else if ( MetaChargingRuleCollection.TAG_NAME.equals(tagName) ) {
			MetaChargingRuleCollection collection = new MetaChargingRuleCollection();
			this.add(collection);
			resultMetaObject = collection;
		} else if ( MetaChargingRuleCondition.TAG_NAME.equals(tagName) ) {
			this.condition = new MetaChargingRuleCondition();
			resultMetaObject = this.condition;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置条件
	 * @param condition 条件
	 */
	public void setCondition(MetaChargingRuleCondition condition) {
		this.condition = condition;
	}
	
	/**
	 * 取得条件
	 * @return 条件
	 */
	public MetaChargingRuleCondition getCondition() {
		return this.condition;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingRuleCollection();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaChargingRuleCollection newObject = (MetaChargingRuleCollection)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDescription(description);
		newObject.setCondition(condition == null ? null : (MetaChargingRuleCondition)condition.clone());
		
		return newObject;
	}

	@Override
	public int getCompositeType() {
		return MetaChargingRule.COLLECTION;
	}
}
