package com.bokesoft.yigo.meta.bpm.total;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 流程的部署信息
 * 
 * @author 刘翔翔
 *
 */
public class MetaProcessDeployInfo extends KeyPairMetaObject {

	public final static String TAG_NAME = "DeployInfo";

	/** 流程的KEY */
	private String key;
	/** 流程的版本 */
	private Integer version = -1;
	/** 流程的初始化日期 */
	private String initDate = DateUtil.getDateFormatText(null,
			"yyyy.MM.dd HH:mm:ss z");

	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProcessDeployInfo();
	}

	public String getInitDate() {
		return initDate;
	}

	public void setInitDate(String initDate) {
		this.initDate = initDate;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		appendString(sb);
		return sb.toString();
	}

	void appendString(StringBuilder sb) {
		sb.append("<");
		sb.append(TAG_NAME);
		sb.append(" KEY=\"");
		sb.append(key);
		sb.append("\" Version=\"");
		sb.append(version);
		sb.append("\" InitDate=\"");
		sb.append(initDate);
		sb.append("\"/>\n");
	}

}
