package com.bokesoft.yigo.meta.bpm.process.transition;

import java.util.Iterator;
import java.util.LinkedList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTransitionCollection extends GenericNoKeyCollection<MetaTransition> {

	public final static String TAG_NAME = "TransitionCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTransitionCollection();
	}

	private MetaTransition createTransition(String tagName) {
		MetaTransition child = null;
		if (tagName.equalsIgnoreCase(MetaSequenceFlow.TAG_NAME))
			child = new MetaSequenceFlow();
		else if (tagName.equalsIgnoreCase(MetaExceptionFlow.TAG_NAME))
			child = new MetaExceptionFlow();
		else if (tagName.equalsIgnoreCase(MetaAssociation.TAG_NAME))
			child = new MetaAssociation();
		else if (tagName.equalsIgnoreCase(MetaDefaultSequenceFlow.TAG_NAME))
			child = new MetaDefaultSequenceFlow();
		return child;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		JSONArray transitionArray = new JSONArray();
		Iterator<MetaTransition> it = this.elementArray.iterator();
		MetaTransition transition = null;
		while (it.hasNext()) {
			transition = it.next();
			transitionArray.put(transition.toJSON());
		}
		obj.put("items", transitionArray);

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		if (json.has("items")) {
			JSONArray transitionArray = json.getJSONArray("items");
			for (int i = 0, size = transitionArray.length(); i < size; ++i) {
				JSONObject transitionObj = transitionArray.getJSONObject(i);
				String tagName = transitionObj.getString("tag-name");
				MetaTransition transition = this.createTransition(tagName);
				transition.fromJSON(transitionObj);
				this.add(transition);
			}
		}
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaTransition child = null;
		if (tagName.equalsIgnoreCase(MetaSequenceFlow.TAG_NAME))
			child = new MetaSequenceFlow();
		else if (tagName.equalsIgnoreCase(MetaExceptionFlow.TAG_NAME))
			child = new MetaExceptionFlow();
		else if (tagName.equalsIgnoreCase(MetaAssociation.TAG_NAME))
			child = new MetaAssociation();
		else if (tagName.equalsIgnoreCase(MetaDefaultSequenceFlow.TAG_NAME))
			child = new MetaDefaultSequenceFlow();
		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		this.add(child);
		return child;
	}

}
