package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;

public class MetaStateAction extends MetaNode {

	public final static String TAG_NAME = "StateAction";

	/** 状态节点的操作 */
	private MetaBPMOperation operation = new MetaBPMOperation();

	/** 对应的批量操作 */
	private MetaBPMOperation batchOperation = new MetaBPMOperation() {
		@Override
		public String getTagName() {
			return MetaBPMOperation.BATCH_TAG_NAME;
		}
	};

	/** 自定义驳回目标节点 */
	private String denyNodeKey = "";

	/** 参与者的集合 */
	private MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();

	/** 关联的状态节点，无须保存 */
	private MetaState stateNode = null;

	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(participatorCollection);
		list.add(operation);
		list.add(batchOperation);
	}

	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child != null)
			return child;
		if (tagName.equalsIgnoreCase(MetaParticipatorCollection.TAG_NAME)) {
			child = participatorCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaBPMOperation.TAG_NAME)) {
			child = operation;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaBPMOperation.BATCH_TAG_NAME)) {
			child = batchOperation;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	@Override
	public int getNodeType() {
		return NodeType.STATE_ACTION;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStateAction newStateAction = (MetaStateAction) super.clone();
		newStateAction.setDenyNodeKey(denyNodeKey);
		newStateAction.setOperation(operation == null ? null : (MetaBPMOperation) operation.clone());
		newStateAction.setParticipatorCollection(participatorCollection == null ? null : (MetaParticipatorCollection) participatorCollection.clone());
		newStateAction.setBatchOperation(batchOperation == null ? null : (MetaBPMOperation) batchOperation.clone());
		newStateAction.setStateNode(stateNode == null ? null : (MetaState)stateNode.clone());
		return newStateAction;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStateAction();
	}

	public MetaBPMOperation getOperation() {
		return operation;
	}

	public void setOperation(MetaBPMOperation operation) {
		this.operation = operation;
	}

	public MetaParticipatorCollection getParticipatorCollection() {
		return participatorCollection;
	}

	public void setParticipatorCollection(MetaParticipatorCollection participatorCollection) {
		this.participatorCollection = participatorCollection;
	}

	public String getDenyNodeKey() {
		return denyNodeKey;
	}

	public void setDenyNodeKey(String denyNodeKey) {
		this.denyNodeKey = denyNodeKey;
	}

	public MetaBPMOperation getBatchOperation() {
		return batchOperation;
	}

	public void setBatchOperation(MetaBPMOperation batchOperation) {
		this.batchOperation = batchOperation;
	}

	public MetaState getStateNode() {
		return stateNode;
	}

	public void setStateNode(MetaState stateNode) {
		this.stateNode = stateNode;
	}
	
	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.denyNodeKey = json.optString("denyNodeKey");
		JSONObject object = json.optJSONObject("operation");
		if(object != null){ 
			this.operation.fromJSON(object);
		}
		object = json.optJSONObject("participatorCollection");
		if(object != null){
			this.participatorCollection.fromJSON(object);
		}
		object = json.optJSONObject("batchOperation");
		if(object != null){
			this.batchOperation.fromJSON(object);
		}
		object = json.optJSONObject("stateNode");
		if(object != null){
			this.stateNode = new MetaState();
			this.stateNode.fromJSON(object);
		}
	}

	@Override
	public JSONObject toJSON() {
		JSONObject jsonObj = super.toJSON();
		JSONHelper.writeToJSON(jsonObj, "denyNodeKey", denyNodeKey);
		if(operation != null){
			jsonObj.put("operation", operation.toJSON());
		}
		if(participatorCollection != null){
			jsonObj.put("participatorCollection", participatorCollection.toJSON());
		}
		if(batchOperation != null) {
			jsonObj.put("batchOperation", batchOperation.toJSON());
		}
		if(stateNode != null){
			jsonObj.put("stateNode", stateNode.toJSON());
		}
		return jsonObj;
	}
}
