package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaServiceTask extends MetaNode {

	public final static String TAG_NAME = "ServiceTask";

	/** 操作 */
	private MetaBaseScript action = null;

	@Override
	public int getNodeType() {
		return NodeType.SERVICE_TASK;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaServiceTask newServiceTask = (MetaServiceTask) super.clone();
		newServiceTask.setAction(action == null ? null : (MetaBaseScript) action.clone());
		return newServiceTask;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { action });
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaServiceTask();
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( BPMConstants.NODE_ACTION.equals(tagName) ) {
				this.action = new MetaBaseScript(BPMConstants.NODE_ACTION);
				resultMetaObject = this.action;
			}
		}
		return resultMetaObject;
	}

	/**
	 * 设置操作
	 * @param action 操作
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}
	
	/**
	 * 取得操作
	 * @return 操作
	 */
	public MetaBaseScript getAction() {
		return action;
	}

	/**
	 * 取得操作的字符串内容
	 * @return 操作的字符串内容
	 */
	public String getStringAction() {
		return this.action == null ? null : this.action.getContent();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("action", this.getStringAction());
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		String s = json.optString("action");
		if ( s != null && !s.isEmpty() ) {
			this.action = new MetaBaseScript(BPMConstants.NODE_ACTION);
		} 
	}

}
