package com.bokesoft.yigo.meta.bpm.process.node;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaParameterCollections;

/**
 * 内联节点
 * 
 * @author 刘翔翔
 *
 */
public class MetaInline extends MetaNode {

	public final static String TAG_NAME = "Inline";

	/** 内联流程的KEY */
	private String inlineProcessKey = "";
	
	/** 流程的KEY公式 */
	private String processKeyFormula = "";
	
	/** 内联流程参数 */
	private MetaParameterCollections inlinePara = null;

	@Override
	public int getNodeType() {
		return NodeType.INLINE;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaInline newInline = (MetaInline) super.clone();
		newInline.setInlineProcessKey(inlineProcessKey);
		newInline.setProcessKeyFormula(processKeyFormula);
		newInline.setInlinePara(null == inlinePara ? null : (MetaParameterCollections)inlinePara.clone());
		return newInline;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaInline();
	}

	public String getInlineProcessKey() {
		return inlineProcessKey;
	}

	public void setInlineProcessKey(String inlineProcessKey) {
		this.inlineProcessKey = inlineProcessKey;
	}
	
	public String getProcessKeyFormula() {
		return processKeyFormula;
	}

	public void setProcessKeyFormula(String processKeyFormula) {
		this.processKeyFormula = processKeyFormula;
	}
	
	public MetaParameterCollections getInlinePara() {
		return inlinePara;
	}

	public void setInlinePara(MetaParameterCollections inlinePara) {
		this.inlinePara = inlinePara;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("inline-process-key", inlineProcessKey);
		obj.put("inline-process-key-formula", processKeyFormula);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.inlineProcessKey = json.optString("inline-process-key");
		this.processKeyFormula = json.optString("inline-process-key-formula");
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (null != child) {
			return child;
		}
		if (tagName.equalsIgnoreCase(MetaParameterCollections.TAG_NAME)) {
			inlinePara = new MetaParameterCollections();
			child = inlinePara;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

}
