package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
public class MetaWorkflowScope extends KeyPairMetaObject {

	public final static String TAG_NAME = "WorkflowScope";
	
	private String processKeys = "";

	@Override
	public String getKey() {
		return processKeys;
	}

	public void setKey(String key) {
		this.processKeys = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaWorkflowScope newWorkflowScope = (MetaWorkflowScope) newInstance();
		newWorkflowScope.setKey(processKeys);

		return newWorkflowScope;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWorkflowScope();
	}
	
	public boolean containKey(String key) {
		if (processKeys != null && !processKeys.isEmpty()) {
			String[] keys= StringUtil.split(processKeys, ",");
			for (String item : keys) {
				if (item.equalsIgnoreCase(key)) {
					return true;
				}
			}
		}
		return false;
	}
	
}
