package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaBPMMonitorSetting extends AbstractMetaObject implements IElementMerge<MetaBPMMonitorSetting>{

	public static final String TAG_NAME = "BPMMonitorSetting";

	/** 监控器集合 */
	private MetaMonitorCollection monitorCollection = null;
	/** 日志记录器集合 */
	private MetaLoggerCollection loggerCollection = null;
	
	public MetaBPMMonitorSetting() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (monitorCollection != null)
			list.add(monitorCollection);
		if (loggerCollection != null)
			list.add(loggerCollection);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置监控器集合
	 * 
	 * @param monitorCollection 监控器集合
	 *            
	 */
	public void setMonitorCollection(MetaMonitorCollection monitorCollection) {
		this.monitorCollection = monitorCollection;
	}

	/**
	 * 取得监控器集合
	 * 
	 * @return 监控器集合
	 */
	public MetaMonitorCollection getMonitorCollection() {
		return this.monitorCollection;
	}
	
	/**
	 * 设置日志记录器集合
	 * 
	 * @param loggerCollection 日志记录器集合
	 *            
	 */
	public void setLoggerCollection(MetaLoggerCollection loggerCollection) {
		this.loggerCollection = loggerCollection;
	}

	/**
	 * 取得日志记录器集合
	 * 
	 * @return 日志记录器集合
	 */
	public MetaLoggerCollection getLoggerCollection() {
		return this.loggerCollection;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaMonitorCollection.TAG_NAME.equals(tagName)) {
			this.monitorCollection = new MetaMonitorCollection();
			resultMetaObject = this.monitorCollection;
		} else if (MetaLoggerCollection.TAG_NAME.equals(tagName)) {
			this.loggerCollection = new MetaLoggerCollection();
			resultMetaObject = this.loggerCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBPMMonitorSetting newObject = new MetaBPMMonitorSetting();
		newObject.setMonitorCollection(monitorCollection == null ? null : (MetaMonitorCollection) monitorCollection.clone());
		newObject.setLoggerCollection(loggerCollection == null ? null : (MetaLoggerCollection) loggerCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMMonitorSetting();
	}

	@Override
	public MetaBPMMonitorSetting toMerge(MetaBPMMonitorSetting obj) {
		if (obj != null) {
			if (monitorCollection != null) {
				monitorCollection.toMerge(obj.monitorCollection);
			}
			if (loggerCollection != null) {
				loggerCollection.toMerge(obj.loggerCollection);
			}
		}
		return this;
	}

}
