package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaRelation extends Participator {

	public final static String TAG_NAME = "Relation";
	
	/** 标签脚本*/
	private MetaBaseScript script;
	/** 节点集合*/
	private MetaRelationNodeCollection nodecollection = null;
	
	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return TAG_NAME;
	}
	
	public MetaRelationNodeCollection getNodeCollection(){
		return nodecollection;
	}
	
	public void setNodecollection(MetaRelationNodeCollection nodecollection) {
		this.nodecollection = nodecollection;
	}
	
	public MetaBaseScript getScript() {
		return script;
	}
	
	public void setScript(MetaBaseScript script) {
		this.script = script;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(nodecollection != null){
			list.add(nodecollection);
		}
		if(script != null){
			list.add(script);
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaobject = null;
		if (MetaRelationNodeCollection.TAG_NAME.equals(tagName)) {
			nodecollection = new MetaRelationNodeCollection();
			resultMetaobject = nodecollection;
		}else if (BPMConstants.RELATION_FORMULA.equals(tagName)) {
			script = new MetaBaseScript(BPMConstants.RELATION_FORMULA);
			resultMetaobject = script;
		}
		return resultMetaobject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaRelation newObject = (MetaRelation)newInstance();
		newObject.setNodecollection(nodecollection == null ? null : (MetaRelationNodeCollection)nodecollection.clone());
		newObject.setScript(script == null ? null : (MetaBaseScript)script.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelation();
	}

}
