package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaQuery extends Participator {

	public final static String TAG_NAME = "Query";

	private String SQL = "";

	private MetaQueryParameterCollection queryParameterCollection;

	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { queryParameterCollection });
	}

	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaQueryParameterCollection.TAG_NAME)) {
			queryParameterCollection = new MetaQueryParameterCollection();
			resultMetaObject = queryParameterCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public String getSQL() {
		return SQL;
	}

	public void setSQL(String sQL) {
		SQL = sQL;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaQuery newQuery = (MetaQuery) newInstance();
		newQuery.setSQL(SQL);
		newQuery.setQueryParameterCollection(queryParameterCollection == null ? null : (MetaQueryParameterCollection) queryParameterCollection.clone());
		return newQuery;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQuery();
	}

	@Override
	public JSONObject toJSON() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void fromJSON(JSONObject json) {
		// TODO Auto-generated method stub

	}

	public MetaQueryParameterCollection getQueryParameterCollection() {
		return queryParameterCollection;
	}
	
	public void setQueryParameterCollection(MetaQueryParameterCollection queryParameterCollection) {
		this.queryParameterCollection = queryParameterCollection;
	}

}
