package com.bokesoft.yigo.meta.bpm.process.attachment;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 节点上的附件信息
 * 
 * @author 刘翔翔
 *
 */
public class MetaNodeAttachment extends AbstractMetaObject {

	public static final String TAG = "NodeAttachment";

	/** 节点附件的KEY */
	private String key = "";

	/** 节点附件的操作类型 */
	private Integer type = AttachmentOperateType.NORMAL;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNodeAttachment clone = new MetaNodeAttachment();
		clone.setKey(key);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNodeAttachment();
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

}
