package com.bokesoft.yigo.meta.base;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class GenericNoKeyCollectionWithKey<T extends AbstractMetaObject> 
		extends KeyPairMetaObject implements Iterable<T>{
	private List<T> elementArray = null;
	public GenericNoKeyCollectionWithKey() {
		elementArray = new CopyOnWriteArrayList<T>();
	}
	
	public T add(T element) {
		elementArray.add(element);
		return element;
	}
	
	public void add(int index, T element) {
		elementArray.add(index, element);
	}
	
	public T set(int index, T element) {
		return elementArray.set(index, element);
	}
	
	public void remove(T element) {
		elementArray.remove(element);
	}
	
	public void remove(int index) {
		elementArray.remove(index);
	}
	
	public int size() {
		return elementArray.size();
	}
	
	public void addAll(int index,Collection<? extends T> c){
		elementArray.addAll(index, c);
	}
	
	public int indexOf(T o) {
		return elementArray.indexOf(o);
	} 

	public void remove(int from, int to) {
		for (int i = to; i >= from; --i) {
			elementArray.remove(i);
		}
	}
	
	public void clear(){
		elementArray.clear();
	}
	
	
	public T get(int index) {
		return elementArray.get(index);
	}
	
	public Iterator<T> iterator() {
		return elementArray.iterator();
	}
	
	@Override
	public boolean needPreLoad() {
		return true;
	}
	
	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc, Object node, 
			Object flag, int runType) throws MetaException {
		Iterator<T> itElement = elementArray.iterator();
		T element = null;
		while ( itElement.hasNext() ) {
			element = itElement.next();
			if ( !element.isAutoGen() ) {
				Object childNode = env.prepare(element, node);
				element.traversal(env, doc, childNode, flag, runType);
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	public AbstractMetaObject clone() {
		GenericNoKeyCollectionWithKey<T> newObject = (GenericNoKeyCollectionWithKey<T>)newInstance();
		Iterator<T> itElement = elementArray.iterator();
		T element = null;
		while ( itElement.hasNext() ) {
			element = itElement.next();
			newObject.add((T)element.clone());
		}
		return newObject;
	}
	
	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public void forEach(Consumer<? super T> action) {		
	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public Spliterator<T> spliterator() {
		return null;
	}
	
	public void sort(Comparator c) {
		elementArray.sort(c);
	}
	
	/** 
	 * 用于统一处理类似的集合类
	 * 
	 * @return
	 */
	public List<T> getList() {
		return elementArray;
	}
}
