package com.bokesoft.yigo.meta.base;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.concurrent.CopyOnWriteArrayList;

import com.bokesoft.yes.common.util.Callback;
public abstract class GenericNoKeyCollection<T extends AbstractMetaObject>
		extends AbstractMetaObject implements Iterable<T> {
	protected List<T> elementArray = null;

	public GenericNoKeyCollection() {
		elementArray = new CopyOnWriteArrayList<T>();
	}
	
	public boolean empty() {
		return this.elementArray.isEmpty();
	}
	
	public void add(T element) {
		elementArray.add(element);
	}

	public void remove(T element) {
		elementArray.remove(element);
	}

	public void remove(int index) {
		elementArray.remove(index);
	}
	
	public void removeAll(Collection<T> elements) {
		elementArray.removeAll(elements);
	}

	public int size() {
		if (elementArray == null) {
			return 0;
		}
		return elementArray.size();
	}
	
	public boolean isEmpty(){
		return size() == 0;
	}

	public T get(int index) {
		return elementArray.get(index);
	}
	
	public int indexOf(T t) {
		if (elementArray == null) {
			return -1;
		}
		return elementArray.indexOf(t);
	}

	public Iterator<T> iterator() {
		return elementArray.iterator();
	}

	public void add(int index, T element) {
		elementArray.add(index, element);
	}
	
	public T set(int index, T element) {
		return elementArray.set(index, element);
	}
	
	public void addAll(int index,Collection<? extends T> c){
		elementArray.addAll(index, c);
	}

	public void remove(int from, int to) {
		for (int i = to; i >= from; --i) {
			elementArray.remove(i);
		}
	}
	public void clear(){
		elementArray.clear();
	}

	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc,
			Object node, Object flag, int runType) throws MetaException {
		Iterator<T> itElement = elementArray.iterator();
		T element = null;
		while (itElement.hasNext()) {
			element = itElement.next();
			if ( !element.isAutoGen() ) {
				Object childNode = env.prepare(element, node);
				element.traversal(env, doc, childNode, flag, runType);
			}
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public AbstractMetaObject clone() {
		GenericNoKeyCollection<T> newObject = (GenericNoKeyCollection<T>) newInstance();
		Iterator<T> itElement = elementArray.iterator();
		T element = null;
		while (itElement.hasNext()) {
			element = itElement.next();
			newObject.add((T) element.clone());
		}

		return newObject;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		Iterator<T> itElement = elementArray.iterator();
		T element = null;
		while (itElement.hasNext()) {
			element = itElement.next();
			element.doPostProcess(flag, callback);
		}
	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public void forEach(Consumer<? super T> action) {
	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public Spliterator<T> spliterator() {
		return null;
	}
	
	public void sort(Comparator<T> c) {
		this.elementArray.sort(c);
	}
	
	/** 
	 * 用于统一处理类似的集合类
	 * 
	 * @return
	 */
	public List<T> getList() {
		return elementArray;
	}
}
