package com.bokesoft.yigo.meta.archive;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaArchiveRuleCollection extends GenericKeyCollection<MetaArchiveRuleGroup>{

	public final static String TAG_NAME = "ArchiveRuleCollection";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaArchiveRuleGroup.TAG_NAME.equalsIgnoreCase(tagName)) {
			resultMetaObject = new MetaArchiveRuleGroup();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaArchiveRuleGroup) resultMetaObject);
		} 
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaArchiveRuleCollection();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		Iterator<MetaArchiveRuleGroup> it = iterator();
		while(it.hasNext()) {
			MetaArchiveRuleGroup group = it.next();
			group.doPostProcess(flag, callback);
		}
	}

}
