package com.bokesoft.yigo.meta.app;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaRefProject定义工程的引用，主要用于说明需要工程集合的情况下使用
 * @author wangyh
 *
 */
public class MetaRefProject extends GenericNoKeyCollection<MetaRefFile> {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "RefProject";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaRefFile result = null;
		if( tagName.equals(MetaRefFile.TAG_NAME) ) {
			result = new MetaRefFile();
			result.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(result);
		}
		return result;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRefProject newObject = (MetaRefProject)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRefProject();
	}

	public MetaRefFile getRefFileByPath(String path) {
		for (int i = 0; i < size(); i++) {
			MetaRefFile metaRefFile = get(i);
			if (metaRefFile.getPath().equals(path)) {
				return metaRefFile;
			}
		}
		return null;
	}

	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
}
