package com.bokesoft.yigo.meta.app;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaClientAppDef定义PC和Web应用程序的定义，包括以下内容
 * <ul>
 * <li>应用程序的全局状态显示信息
 * </ul>
 * @author wangyh
 *
 */
public class MetaClientAppDef extends AbstractMetaObject {
	/** 状态信息 */
	private MetaClientAppStatusInfo statusInfo = null;
	
	public MetaClientAppDef() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "AppDef";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置全局状态信息
	 * @param statusInfo 全局状态信息
	 */
	public void setStatusInfo(MetaClientAppStatusInfo statusInfo) {
		this.statusInfo = statusInfo;
	}
	
	/**
	 * 取得全局状态信息
	 * @return 全局状态信息
	 */
	public MetaClientAppStatusInfo getStatusInfo() {
		return this.statusInfo;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaClientAppStatusInfo.TAG_NAME.equals(tagName) ) {
			this.statusInfo = new MetaClientAppStatusInfo();
			resultMetaObject = this.statusInfo;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaClientAppDef newObject = (MetaClientAppDef)newInstance();
		newObject.setStatusInfo(statusInfo == null ? null : (MetaClientAppStatusInfo)statusInfo.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaClientAppDef();
	}

}
