package com.bokesoft.yes.meta.process;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;

/**
 * 用于处理表单间的继承
 *
 * @author 陈瑞
 */
public class MetaFormExtendProcess {
    private IMetaFactory metaFactory;
    private MetaForm metaForm;
    private MetaForm extForm;
    private StringHashMap<MetaComponent> comsMap = null;

    public MetaFormExtendProcess(IMetaFactory metaFactory, MetaForm metaForm) {
        super();
        this.metaFactory = metaFactory;
        this.metaForm = metaForm;
        this.comsMap = StringHashMap.newInstance();
    }

    private void buildMap() {
        MetaBody metaBody = metaForm.getMetaBody();

        Stack<MetaComponent> stack = new Stack<MetaComponent>();
        for (int i = 0, size = metaBody.size(); i < size; ++i) {
            stack.push(metaBody.get(i));
        }

        MetaComponent com = null;
        while (!stack.isEmpty()) {
            com = stack.pop();
            this.comsMap.put(com.getKey(), com);

            for (int i = 0, size = com.getComponentCount(); i < size; ++i) {
                stack.add(com.getComponent(i));
            }
        }
    }

    /**
     * 合并原单内容
     * @throws Throwable
     */
    public void process() throws Throwable {
        String extend = metaForm.getExtend();
        if (extend == null || extend.isEmpty()) {
            return;
        }

        buildMap();

        extForm = metaFactory.getMetaForm(extend);
        processNewExtField();
        processComponents();
        processMacroCollection();
        processQueryCollection();
        processParaCollection();
        processScriptCollection();
        processUICheckCollection();

        metaForm.merge(extForm);
    }

    /**
     * 指定表单，，，合并指定表单的内容
     * @param parentForm
     * @throws Throwable
     */
    public void process(MetaForm parentForm) throws Throwable {
        buildMap();

        extForm = parentForm;
        processNewExtField();
        processComponents();
        processMacroCollection();
        processQueryCollection();
        processParaCollection();
        processScriptCollection();
        processUICheckCollection();

        metaForm.merge(extForm);
    }

    /**
     * 处理继承组件属性并合并父组件
     */
    private void processComponents() throws Exception {
        List<MetaComponent> extComs = extForm.getAllComponents();
        Iterator<MetaComponent> it = extComs.iterator();
        MetaComponent metaCom = null;
        MetaComponent extCom = null;
        MetaComponent cloneCom = null;

        MetaBlock block = metaForm.getPrimaryBlock();
        MetaPanel root = (MetaPanel) block.getRoot();

        while (it.hasNext()) {
            extCom = it.next();

            metaCom = this.comsMap.get(extCom.getKey());

            if (metaCom != null) {
                if (metaCom.getControlType() != extCom.getControlType()) {
                    throw new MetaException(MetaException.CONTROL_TYPE_DOES_NOT_MATCH,
                            SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ControlTypeDoesNotMatch), metaForm.getKey()));
                }

                switch (metaCom.getControlType()) {
                    case ControlType.GRID:
                        processGrid((MetaGrid) metaCom, (MetaGrid) extCom);
                        break;
                    case ControlType.LISTVIEW:
                        processListView((MetaListView) metaCom, (MetaListView) extCom);
                        break;
                    default:
                        metaCom.merge(extCom);
                        break;
                }
            } else {
                if (!extCom.isPanel()) {
                    if ((extCom instanceof MetaSubDetail && ((MetaSubDetail) extCom).getRoot() instanceof MetaGrid)
                            || (extCom instanceof MetaSubDetail && ((MetaSubDetail) extCom).getRoot() instanceof MetaGridLayoutPanel)) {
                        // 不处理
                    } else {
                        if (!this.metaForm.getAllUIComponents().containsKey(extCom.getKey())){
                            cloneCom = (MetaComponent) extCom.depthClone();
                            cloneCom.setExtend(true);
                            cloneCom.setVisible("false");
                            root.addComponent(cloneCom);
                        }
                    }
                }
            }
        }

    }
    /**
     * 处理未继承组件设置NewExtField属性为true
     */
    private void processNewExtField() {
        List<MetaComponent> metaComs = this.metaForm.getAllComponents();
        this.comsMap.forEach((key,metaCom)->{
            if (extForm.componentByKey(key) == null) {
                if (!metaCom.isPanel()) {
                    if ((metaCom instanceof MetaSubDetail && ((MetaSubDetail) metaCom).getRoot() instanceof MetaGrid)
                            || (metaCom instanceof MetaSubDetail && ((MetaSubDetail) metaCom).getRoot() instanceof MetaGridLayoutPanel)) {
                        // 不处理
                    } else {
                        metaCom.setNewExtField(true);
                    }
                }
            }
        });
    }

    private void processListView(MetaListView metaListView, MetaListView extListView) {
        // 自身属性
        metaListView.merge(extListView);

        // 列合并
        MetaListViewColumnCollection lvc = metaListView.getColumnCollection();
        MetaListViewColumnCollection elvc = extListView.getColumnCollection();
        Iterator<MetaListViewColumn> it = lvc.iterator();

        MetaListViewColumn lvColumn = null;
        MetaListViewColumn extColumn = null;

        while (it.hasNext()) {
            lvColumn = it.next();
            extColumn = elvc.get(lvColumn.getKey());

            if (extColumn != null) { // 合并列
                lvColumn.merge(extColumn);
            } else { // 新增的列
                lvColumn.merge(new MetaListViewColumn());
            }

            // 其他不做处理
        }
    }

    /**
     * 处理表格本身以及行和单元格属性的继承,源表格中未被继承的列合并到马甲新的表格中   // TODO  需要添加源表格的列？？？而不是继承表单保证表格的完整性
     */
    private void processGrid(MetaGrid metaGrid, MetaGrid extGrid) {
        // 自身属性
        metaGrid.merge(extGrid);
    }


    /**
     * 合并宏公式
     */
    private void processMacroCollection() {
        MetaMacroCollection mac1 = metaForm.getMacroCollection();
        MetaMacroCollection mac2 = extForm.getMacroCollection();
        MetaMacroCollection mac3 = null;
        if (mac2 != null) {
            if (mac1 != null) {
                Iterator<MetaMacro> it = mac2.iterator();
                MetaMacro macro = null;
                MetaMacro macro1 = null;

                while (it.hasNext()) {
                    macro = it.next();

                    macro1 = mac1.get(macro.getKey());
                    if (macro1 != null) {
                        macro1.merge(macro);
                    } else {
                        mac1.add((MetaMacro) macro.clone());
                    }
                }
                mac3 = mac1;
            } else {
                mac3 = (MetaMacroCollection) mac2.clone();
            }

            metaForm.setMacroCollection(mac3);
        }
    }

    /**
     * 合并查询
     */
    private void processQueryCollection() {
        MetaQueryCollection qc1 = metaForm.getQueryCollection();
        MetaQueryCollection qc2 = extForm.getQueryCollection();
        MetaQueryCollection qc = null;
        if (qc2 != null) {
            if (qc1 != null) {
                Iterator<MetaQuery> it = qc2.iterator();
                MetaQuery query = null;
                MetaQuery query2 = null;

                while (it.hasNext()) {
                    query = it.next();
                    query2 = qc1.get(query.getKey());

                    if (query2 != null) {
                        query2.merge(query);
                    } else {
                        qc1.add((MetaQuery) query.clone());
                    }
                }
                qc = qc1;
            } else {
                qc = (MetaQueryCollection) qc2.clone();
            }

            metaForm.setQueryCollection(qc);
        }
    }

    /**
     * 合并参数集
     *
     * @throws Throwable
     */
    private void processParaCollection() throws Throwable {
        MetaFormParaCollection pc1 = metaForm.getFormParaCollection();
        MetaFormParaCollection pc2 = extForm.getFormParaCollection();
        MetaFormParaCollection pc3 = null;
        if (pc2 != null) {
            if (pc1 != null) {
                Iterator<MetaFormPara> it = pc2.iterator();
                MetaFormPara p1 = null;
                MetaFormPara p2 = null;

                while (it.hasNext()) {
                    p1 = it.next();
                    p2 = pc1.get(p1.getKey());

                    if (p2 != null) {
                        p2.merge(p1);
                    } else {
                        pc1.add((MetaFormPara) p1.clone());
                    }
                }
                pc3 = pc1;
            } else {
                pc3 = (MetaFormParaCollection) pc2.clone();
            }

            metaForm.setFormParaCollection(pc3);
        }
    }

    /**
     * 合并脚本
     */
    private void processScriptCollection() throws Throwable {
        MetaScriptCollection sc1 = metaForm.getScriptCollection();
        MetaScriptCollection sc2 = extForm.getScriptCollection();
        MetaScript sc = null;

        if (sc2 != null) {
            MetaScript load = sc2.getLoad();
            MetaScript save = sc2.getSave();
            if (sc1 != null) {
                if (load != null) {
                    sc = sc1.getLoad();
                    if (sc != null) {
                        sc.merge(load);
                    } else {
                        sc1.setLoad((MetaScript) load.clone());
                    }
                }

                if (save != null) {
                    sc = sc1.getSave();
                    if (sc != null) {
                        sc.merge(save);
                    } else {
                        sc1.setSave((MetaScript) save.clone());
                    }
                }
            } else {
                metaForm.setScriptCollection((MetaScriptCollection) sc2.clone());
            }
        }
    }

    /**
     * 检查规则不合并,直接继承或者覆盖
     */
    private void processUICheckCollection() throws Throwable {
        MetaUICheckRuleCollection co = metaForm.getUICheckRuleCollection();
        if (co == null) {
            MetaUICheckRuleCollection co2 = extForm.getUICheckRuleCollection();
            if (co2 != null) {
                metaForm.setUICheckRuleCollection((MetaUICheckRuleCollection) co2.clone());
            }
        }
    }

}
