package com.bokesoft.yes.meta.persist.dom.xml.parse;

public class CharUtil
{
  public static boolean isInIt(char c, char[] arr)
  {
    if (arr == null) {
      return false;
    }
    for (char i : arr) {
      if (i == c) {
        return true;
      }
    }
    return false;
  }

  public static boolean isNameStartChar(char c)
  {
    return (isLetter(c)) || (isZhChar(c)) || (c == '_');
  }

  public static boolean isNameChar(char c) {
    return (isNameStartChar(c)) || (isNum(c));
  }

  public static boolean isZhChar(char c)
  {
    return (c >= '一') && (c <= 40869);
  }

  public static boolean isBigLetter(char c)
  {
    return (c >= 'A') && (c <= 'Z');
  }

  public static boolean isSmallLetter(char c)
  {
    return (c >= 'a') && (c <= 'z');
  }

  public static boolean isLetter(char c)
  {
    return (isBigLetter(c)) || (isSmallLetter(c));
  }

  public static boolean isBlank(char c)
  {
    return (c == ' ') || 
      (c == '\t') || 
      (c == '\r') || 
      (c == '\n');
  }

  public static boolean isNum(char c)
  {
    return (c >= '0') && 
      (c <= '9');
  }
}