package com.bokesoft.yes.meta.persist.dom.taskflow;

/**
 * 参数类型
 */
public class ParaType {
	
	/** 引用　*/
	public static final int REF = 0;
	public static final String STR_REF = "Ref";
	
	/** 常量值 */
	public static final int CONST = 1;
	public static final String STR_CONST = "Const";
	
	/** 公式 */
	public static final int FORMULA = 2;
	public static final String STR_FORMULA = "Formula";
	
	/**
	 *参数类型
	 * @param s 字符串，取值范围为
	 * <ul>
	 * <li>{@link #STR_REF}
	 * <li>{@link #STR_CONST}
	 * <li>{@link #STR_FORMULA}
	 * </ul>
	 * @return 如果s的取值在取值范围内，返回相应的运算符，否则返回-1
	 */
	public static int parse(String s) {
		int op = -1;
		if ( STR_REF.equals(s) ) {
			op = REF;
		} else if ( STR_CONST.equals(s) ) {
			op = CONST;
		} else if ( STR_FORMULA.equals(s) ) {
			op = FORMULA;
		}
		return op;
	}
	
	/**
	 * 参数类型字符串表示
	 * @param type 运算符，取值范围为
	 * <ul>
	 * <li>{@link #REF}
	 * <li>{@link #CONST}
	 * <li>{@link #FORMULA}
	 * </ul>
	 * @return 如果type的取值在取值范围内，返回相应的字符串表示，否则返回空字符串
	 */
	public static String format(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch ( type ) {
		case REF:
			s = STR_REF;
			break;
		case CONST:
			s = STR_CONST;
			break;
		case FORMULA:
			s = STR_FORMULA;
			break;
		}
		return s;
	}
}
