package com.bokesoft.yes.meta.persist.dom.task.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.task.MetaTaskConstants;
import com.bokesoft.yigo.meta.task.node.MetaTaskWorker;

public class MetaTaskWorkerAction<T extends MetaTaskWorker> extends MetaTaskNodeAction<T> {
@Override
public void load(Document doc, Element node, T meta, int runType) {
	super.load(doc, node, meta, runType);
	meta.setUrl(DomHelper.readAttr(node, MetaTaskConstants.NODE_URL, ""));
	meta.setImpl(DomHelper.readAttr(node, MetaTaskConstants.NODE_IMPL, ""));
}

@Override
	public void save(Document doc, Element node, T meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, MetaTaskConstants.NODE_URL, meta.getUrl(), "");
		DomHelper.writeAttr(node, MetaTaskConstants.NODE_IMPL, meta.getImpl(), "");

	}
}
