package com.bokesoft.yes.meta.persist.dom.task;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.task.action.MetaTaskProcessAction;
import com.bokesoft.yes.meta.persist.dom.task.action.data.MetaTaskDataInputAction;
import com.bokesoft.yes.meta.persist.dom.task.action.data.MetaTaskDataItemAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskBeginAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskDecisionAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskEndAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskExceptionAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskForkAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskJoinAction;
import com.bokesoft.yes.meta.persist.dom.task.action.node.MetaTaskWorkerAction;
import com.bokesoft.yes.meta.persist.dom.task.action.transition.MetaTaskExceptionFlowAction;
import com.bokesoft.yes.meta.persist.dom.task.action.transition.MetaTaskSequenceFlowAction;
import com.bokesoft.yes.meta.persist.dom.task.action.transition.MetaTaskTransitionCollectionAction;
import com.bokesoft.yigo.meta.task.MetaTaskProcess;
import com.bokesoft.yigo.meta.task.data.MetaTaskDataInput;
import com.bokesoft.yigo.meta.task.data.MetaTaskDataItem;
import com.bokesoft.yigo.meta.task.node.MetaTaskBegin;
import com.bokesoft.yigo.meta.task.node.MetaTaskDecision;
import com.bokesoft.yigo.meta.task.node.MetaTaskEnd;
import com.bokesoft.yigo.meta.task.node.MetaTaskException;
import com.bokesoft.yigo.meta.task.node.MetaTaskFork;
import com.bokesoft.yigo.meta.task.node.MetaTaskJoin;
import com.bokesoft.yigo.meta.task.node.MetaTaskWorker;
import com.bokesoft.yigo.meta.task.transition.MetaTaskExceptionFlow;
import com.bokesoft.yigo.meta.task.transition.MetaTaskSequenceFlow;
import com.bokesoft.yigo.meta.task.transition.MetaTaskTransitionCollection;

public class MetaTaskProcessActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
			{MetaTaskProcess.TAG_NAME, new MetaTaskProcessAction()},
			{MetaTaskBegin.TAG_NAME, new MetaTaskBeginAction()},
			{MetaTaskEnd.TAG_NAME, new MetaTaskEndAction()},
			{MetaTaskDecision.TAG_NAME, new MetaTaskDecisionAction()},
			{MetaTaskFork.TAG_NAME, new MetaTaskForkAction()},
			{MetaTaskJoin.TAG_NAME, new MetaTaskJoinAction()},
			{MetaTaskWorker.TAG_NAME, new MetaTaskWorkerAction<MetaTaskWorker>()},
			{MetaTaskException.TAG_NAME, new MetaTaskExceptionAction()},
			{MetaTaskDataInput.TAG_NAME, new MetaTaskDataInputAction()},
			{MetaTaskDataItem.TAG_NAME, new MetaTaskDataItemAction()},
			{MetaTaskTransitionCollection.TAG_NAME, new MetaTaskTransitionCollectionAction()},
			{MetaTaskSequenceFlow.TAG_NAME, new MetaTaskSequenceFlowAction()},
			{MetaTaskExceptionFlow.TAG_NAME, new MetaTaskExceptionFlowAction()}
		};
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		// TODO Auto-generated method stub
		return null;
	}
	
	private static MetaTaskProcessActionMap INSTANCE = null;
	public static MetaTaskProcessActionMap getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new MetaTaskProcessActionMap();
		}
		return INSTANCE;
	}
	

}
