package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;

public class MetaProjectProfileAction extends BaseDomAction<AbstractMetaObject> {

	@Override
	public void load(Document document, Element element, AbstractMetaObject meta, int runType) {
		MetaProjectProfile metaProjectProfile = (MetaProjectProfile)meta;
		metaProjectProfile.setKey(DomHelper.readAttr(element, "Key", ""));
		metaProjectProfile.setCaption(DomHelper.readAttr(element, "Caption", ""));
		metaProjectProfile.setRefPath(DomHelper.readAttr(element, "RefPath", ""));
		metaProjectProfile.setDiffSourceProjects(DomHelper.readAttr(element, MetaConstants.DIFF_SOURCE_PROJECTS, ""));
	}

	@Override
	public void save(Document document, Element element, AbstractMetaObject meta, int runType) {
		MetaProjectProfile metaProjectProfile = (MetaProjectProfile)meta;
		DomHelper.writeAttr(element, "Key", metaProjectProfile.getKey(), "");
		DomHelper.writeAttr(element, "Caption", metaProjectProfile.getCaption(), "");
		DomHelper.writeAttr(element, "RefPath", metaProjectProfile.getRefPath(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_SOURCE_PROJECTS, metaProjectProfile.getDiffSourceProjects(), "");
	}

}

