package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaGenericProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

/**
 * 将excel格式的模板文件取出
 * 
 * @author chenbb
 *
 */
public class MetaExcelFileTemplateScanLoad extends BaseMetaScanLoad {
	
	private HashMapIgnoreCase<MetaGenericProfile> excelTemplateFiles= null;
	private Map<String, MetaGenericProfile> map = null;
	
	public MetaExcelFileTemplateScanLoad(HashMapIgnoreCase<MetaGenericProfile> excelTemplateFiles, IMetaResolver resolver,
			MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.EXCELTEMPLATE_FOLD, context);
		this.excelTemplateFiles = excelTemplateFiles;
		map = new ConcurrentHashMap<>();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName)
			throws Exception {
		MetaGenericProfile profile = new MetaGenericProfile();
		profile.setProject(metaProject);
		profile.setResource(filePath);
		this.map.put(fileName, profile);
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaExcelTemplateProfile profile) {
		
	}
	
	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	protected String getFileFilter() {
		//此处可能存在多种excel格式 比如 .xls、。xlsx,父类中未处理多种文件格式的情况, 关于文件格式过滤在  IMetaResourceFilter 中处理
		return "";
	}

	private void merge() {
		if(map.isEmpty()) {
			return;
		}
		try {
			excelTemplateFiles.putAll(map);
		}finally {
			map.clear();
		}
	}
	
	public HashMapIgnoreCase<MetaGenericProfile> getMetaExcelFileTemplate() {
		merge();
		return this.excelTemplateFiles;
	}
}
