package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.setting.MetaBPMMTable;

public class MetaBPMMTableAction extends BaseDomAction<MetaBPMMTable> {

	@Override
	public void load(Document document, Element element, MetaBPMMTable meta, int runType) {
		meta.setActivateMigration(DomHelper.readAttr(element, BPMConstants.ACTIVATE_MIGRATION, true));

	}

	@Override
	public void save(Document document, Element element, MetaBPMMTable meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.QUERY_RETREAT_WORKITEM, meta.isActivateMigration(), true);
	}
}
