package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaAttachmentService;

public class MetaAttachmentServiceAction extends BaseDomAction<MetaAttachmentService> {

	@Override
	public void load(Document document, Element element,
			MetaAttachmentService meta, int runType) {
		meta.setDefaultProvider(DomHelper.readAttr(element, MetaConstants.ATTACHMENTSERVICE_DEFAULT, ""));
		meta.setMaxSize(DomHelper.readAttr(element, MetaConstants.ATTACHMENTSERVICE_MAXSIZE, -1));
		meta.setAllowedTypes(DomHelper.readAttr(element, MetaConstants.ATTACHMENTSERVICE_ALLOWEDTYPES, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaAttachmentService meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENTSERVICE_DEFAULT, meta.getDefaultProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENTSERVICE_MAXSIZE, meta.getMaxSize(), -1);
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENTSERVICE_ALLOWEDTYPES, meta.getAllowedTypes(), "");
	}

}
