package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportDisplay;

public class MetaReportDisplayAction extends BaseDomAction<MetaReportDisplay> {

	@Override
	public void load(Document document, Element element, MetaReportDisplay meta, int runType) {
		meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_HALIGN, HAlignment.STR_CENTER)));
		meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_VALIGN, VAlignment.STR_CENTER))); 
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.FORMAT_BACKCOLOR, ""));
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.FORMAT_FORECOLOR, ""));
		meta.setShowType(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_SHOWTYPE, ""));
		meta.setEncodingType(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_ENCODINGTYPE, "UTF-8"));
		meta.setErrorCorrectionLevel(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_ERRORCORRECTIONLEVEL, "L"));
		meta.setMargin(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_MARGIN, 0));
		meta.setEnableZeroShow(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_ENABLE_ZERO_SHOW, false));
		meta.setZeroShowString(DomHelper.readAttr(element, MetaReportConstants.DISPLAY_ZERO_SHOW_STRING, ""));
	}

	@Override
	public void save(Document document, Element element, MetaReportDisplay meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_HALIGN, HAlignment.toString(meta.getHAlign()), HAlignment.STR_CENTER);
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_VALIGN, VAlignment.toString(meta.getVAlign()), VAlignment.STR_CENTER);
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_SHOWTYPE, meta.getShowType(), "");
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_ENCODINGTYPE, meta.getEncodingType(), "UTF-8");
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_ERRORCORRECTIONLEVEL, meta.getErrorCorrectionLevel(), "L");
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_MARGIN, meta.getMargin(), 0);
		
		String backColor = meta.getBackColor();
		if ( "White".equalsIgnoreCase(backColor) || "#ffffff".equalsIgnoreCase(backColor) ) {
			backColor = "";
		}
		DomHelper.writeAttr(element, MetaConstants.FORMAT_BACKCOLOR, backColor, "");
		String foreColor = meta.getForeColor();
		if ( "Black".equalsIgnoreCase(foreColor) || "#000000".equalsIgnoreCase(foreColor) ) {
			foreColor = "";
		}
		DomHelper.writeAttr(element, MetaConstants.FORMAT_FORECOLOR, foreColor, "");
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_ENABLE_ZERO_SHOW, meta.isEnableZeroShow(), false);
		DomHelper.writeAttr(element, MetaReportConstants.DISPLAY_ZERO_SHOW_STRING, meta.getZeroShowString(), "");
	}

}
