package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;

public class MetaReportDataTableAction extends BaseDomAction<MetaReportDataTable> {

	@Override
	public void load(Document document, Element element,
			MetaReportDataTable meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setSourceType(TableSourceType.parse(DomHelper.readAttr(element, MetaReportConstants.TABLE_SOURCE_TYPE, "")));
		meta.setStateument(DomHelper.readAttr(element, MetaReportConstants.TABLE_STATEMENT, ""));
		meta.setFilter(DomHelper.readAttr(element, MetaReportConstants.TABLE_FILTER, ""));
		meta.setDBTableKey(DomHelper.readAttr(element, MetaReportConstants.TABLE_DB_TABLE_KEY, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaReportDataTable meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaReportConstants.TABLE_SOURCE_TYPE, TableSourceType.toString(meta.getSourceType()), "");
		DomHelper.writeAttr(element, MetaReportConstants.TABLE_STATEMENT, meta.getStateument(), "");
		DomHelper.writeAttr(element, MetaReportConstants.TABLE_FILTER, meta.getFilter(), "");
		DomHelper.writeAttr(element, MetaReportConstants.TABLE_DB_TABLE_KEY, meta.getDBTableKey(), "");
	}

}
