package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportColumnExpand;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.ReportColumnExpandSourceType;
import com.bokesoft.yigo.meta.report.ReportColumnExpandType;

public class MetaReportColumnExpandAction extends MetaBaseScriptAction<MetaReportColumnExpand> {
	@Override
	public void load(Document document, Element element, MetaReportColumnExpand meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setExpandType(ReportColumnExpandType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND_TYPE, "")));
		meta.setSourceType(ReportColumnExpandSourceType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND_SOURCE_TYPE, "")));
		meta.setColumnKey(DomHelper.readAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND_COLUMN_KEY, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaReportColumnExpand meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND_TYPE, ReportColumnExpandType.toString(meta.getExpandType()), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND_SOURCE_TYPE, ReportColumnExpandSourceType.toString(meta.getSourceType()), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_COLUMN_EXPAND_COLUMN_KEY, meta.getColumnKey(), "");
	}
}
