package com.bokesoft.yes.meta.persist.dom.relation.path.check;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.path.check.MetaCheckTarget;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaCheckTargetAction extends BaseDomAction<MetaCheckTarget> {

	@Override
	public void load(Document document, Element element, MetaCheckTarget meta, int runType) {
		meta.setBlacklist(DomHelper.readAttr(element, MetaRelationConstants.BLACKLIST, false));
	}

	@Override
	public void save(Document document, Element element, MetaCheckTarget meta, int runType) {
		DomHelper.writeAttr(element, MetaRelationConstants.BLACKLIST, meta.isBlacklist(), false);
	}

}
