package com.bokesoft.yes.meta.persist.dom.mobiledef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mobiledef.MetaSoundItem;

public class MetaSoundItemAction extends BaseDomAction<MetaSoundItem>{

	@Override
	public void load(Document document, Element element, MetaSoundItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setPath(DomHelper.readAttr(element, MetaConstants.SOUNDITEM_PATH, ""));
		String leftVolume = DomHelper.readAttr(element, MetaConstants.SOUNDITEM_LEFTVOLUME, "");
		if(leftVolume != null && !leftVolume.isEmpty()){
			meta.setLeftVolume(Float.parseFloat(leftVolume));
		}    
		String rightVolume = DomHelper.readAttr(element, MetaConstants.SOUNDITEM_RIGHTVOLUME, "");
		if(rightVolume != null && !rightVolume.isEmpty()){
			meta.setRightVolume(Float.parseFloat(rightVolume));
		}
		meta.setLoop(DomHelper.readAttr(element, MetaConstants.SOUNDITME_LOOP, -1));
		meta.setPriority(DomHelper.readAttr(element, MetaConstants.SOUNDITEM_PRIORITY, 0));
		
		String rate = DomHelper.readAttr(element, MetaConstants.SOUNDITEM_RATE, "");
		if(rate != null && !rate.isEmpty()){
			meta.setRate(Float.parseFloat(rate));
		}
		
	}

	@Override
	public void save(Document document, Element element, MetaSoundItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SOUNDITEM_PATH, meta.getPath(), "");
		DomHelper.writeAttr(element, MetaConstants.SOUNDITEM_LEFTVOLUME, meta.getLeftVolume() + "", "1");
		DomHelper.writeAttr(element, MetaConstants.SOUNDITEM_RIGHTVOLUME, meta.getRightVolume() + "", "1");
		DomHelper.writeAttr(element, MetaConstants.SOUNDITME_LOOP, meta.getLoop(), -1);
		DomHelper.writeAttr(element, MetaConstants.SOUNDITEM_PRIORITY, meta.getPriority(), 0);
		DomHelper.writeAttr(element, MetaConstants.SOUNDITEM_RATE, meta.getRate() + "", "1");
	}

}
