package com.bokesoft.yes.meta.persist.dom.form.dynamic;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaConditionAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaStatementAction;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaParameterAction;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaParameterCollectionAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.MetaDefaultItemAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaComboFilterAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaFilterAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaFilterValueAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaItemFilterAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaQueryDefAction;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeGroup;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;

public class MetaDynamicCellActionMap extends MetaActionMap{

	@Override
	protected Object[][] getActionLookupTable() {
		MetaBaseScriptAction<?> metaScriptAction = new MetaBaseScriptAction<MetaBaseScript>();
		return new Object[][] {
			{ MetaCellTypeTable.TAG_NAME , new MetaCellTypeTableAction() },
			{ MetaCellTypeGroup.TAG_NAME , new MetaCellTypeGroupAction() },
			{ MetaCellTypeDef.TAG_NAME , new MetaCellTypeDefAction()},
			{ MetaConstants.COMBOBOX_FORMULAITEMS, metaScriptAction },
			{ MetaQueryDef.TAG_NAME, new MetaQueryDefAction() },
			{ MetaStatement.TAG_NAME, new MetaStatementAction() },
			{ MetaParameterCollection.TAG_NAME,new MetaParameterCollectionAction() },
			{ MetaParameter.TAG_NAME, new MetaParameterAction() },
			{ MetaItemFilter.TAG_NAME, new MetaItemFilterAction() },
			{ MetaDefaultItem.TAG_NAME, new MetaDefaultItemAction() },
			{ MetaFilter.TAG_NAME, new MetaFilterAction() },
			{ MetaFilterValue.TAG_NAME, new MetaFilterValueAction() },
			{ MetaConstants.Event_OnClick, metaScriptAction },
			{ MetaConstants.Event_FinishedEvent, metaScriptAction },
			{ MetaConstants.CONDITION, new MetaConditionAction() },
			{ MetaComboFilter.TAG_NAME, new MetaComboFilterAction()},
	};
	}
	
	private static MetaDynamicCellActionMap instance = null;
	
	public static MetaDynamicCellActionMap getInstance() {
		if( instance == null ) {
			instance = new MetaDynamicCellActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}

}
