package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;

public class MetaFluidTableLayoutAction extends MetaComponentLayoutAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaFluidTableLayout metaFluidTableLayout = (MetaFluidTableLayout)meta;
		metaFluidTableLayout.setRepeatCount(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATCOUNT, 1));
		metaFluidTableLayout.setRepeatGap(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATGAP, 0));
		metaFluidTableLayout.setRowGap(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWGAP, 0));
		metaFluidTableLayout.setColumnGap(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_COLUMNGAP, 0));
		metaFluidTableLayout.setRowHeight(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWHEIGHT, 0));
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaFluidTableLayout metaFluidTableLayout = (MetaFluidTableLayout)meta;
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATCOUNT, metaFluidTableLayout.getRepeatCount(), 1);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATGAP, metaFluidTableLayout.getRepeatGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWGAP, metaFluidTableLayout.getRowGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_COLUMNGAP, metaFluidTableLayout.getColumnGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWHEIGHT, metaFluidTableLayout.getRowHeight(), 0);
	}
}
