package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaWizardPanel;



public class MetawizardPanelAction extends MetaPanelAction<MetaWizardPanel>{
	@Override
	 public void load(Document document, Element element, MetaWizardPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setWizardPosition(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.wizardPanel_TABPOSITION, DirectionType.STR_TOP)));
	}
	@Override
	public void save(Document document, Element element,MetaWizardPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.wizardPanel_TABPOSITION, DirectionType.toString(meta.getWizardPosition()), DirectionType.STR_TOP);
	}
}
