package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;

/**
 * 基础布局面板对象在保存和载入时的相关动作
 * 
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaPanelExtAction<T extends MetaPanel> extends MetaComponentExtAction<T> {
	@Override
	public void load(Document document, Element element, T meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setOverflowX(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_X, "")));
		meta.setOverflowY(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_Y, "")));
		meta.setBackImage(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE, null));
		meta.setBackImagePosition(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_BACKIMAGE_POSITION, "")));
		meta.setBackImageRepeatX(DomHelper.readBool(element, MetaConstants.COMPONENT_BACKIMAGE_REPEAT_X, null));
		meta.setBackImageRepeatY(DomHelper.readBool(element, MetaConstants.COMPONENT_BACKIMAGE_REPEAT_Y, null));
		meta.setLayoutAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, ""));
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {

	}
}
