package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.RowExpandType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowExpand;

public class MetaRowExpandAction extends MetaBaseScriptAction<MetaRowExpand>{

	@Override
	public void load(Document document, Element element, MetaRowExpand meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setExpandType(RowExpandType.parse(DomHelper.readAttr(element, MetaConstants.EXPAND_TYPE, RowExpandType.STR_DICT)));
		meta.setCellKey(DomHelper.readAttr(element, MetaConstants.EXPAND_CELLKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaRowExpand meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_TYPE, RowExpandType.toString(meta.getExpandType()), RowExpandType.STR_DICT);
		DomHelper.writeAttr(element, MetaConstants.EXPAND_CELLKEY, meta.getCellKey(), "");
	}
}
