package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SubDetailLinkType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;

public class MetaGridRowExtAction extends BaseDomAction<MetaGridRow> {
	
	@Override
	public void load(Document document, Element element, MetaGridRow meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setRowType(RowType.parse(DomHelper.readAttr(element, MetaConstants.ROW_TYPE, "")));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.ROW_HEIGHT, 32));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, null));
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.GROUP_KEY, null));
		meta.setDetailKey(DomHelper.readAttr(element, MetaConstants.DETAIL_KEY, null));
		meta.setDefaultLayer(DomHelper.readInt(element, MetaConstants.ROW_DEFAULTLAYER, null));
		meta.setLinkType(SubDetailLinkType.parse(DomHelper.readAttr(element, MetaConstants.LINK_TYPE, "")));
		meta.setSource(DomHelper.readAttr(element, MetaConstants.SOURCE_FIELDS, null));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.TARGET_FIELDS, null));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, null));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
		meta.setFrozen(DomHelper.readBool(element, MetaConstants.COMMON_FREEZE, null));
	}

	@Override
	public void save(Document document, Element element, MetaGridRow meta,
			int runType) {

	}

}
