package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.SelectionMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;

public class MetaGridAction extends MetaComponentAction<MetaGrid> {

	@Override
	public void load(Document document, Element element, MetaGrid meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.GRID_PAGEROWCOUNT, 50));
		meta.setPageIndicatorCount(DomHelper.readAttr(element, MetaConstants.GRID_PAGEINDICATORCOUNT, 5));
		meta.setRowRange(DomHelper.readAttr(element, MetaConstants.GRID_ROWRANGE, ""));
		meta.setNewEmptyRow(DomHelper.readAttr(element, MetaConstants.GRID_NEW_EMPTY_ROW, "true"));
		meta.setShowRowHead(DomHelper.readAttr(element, MetaConstants.GRID_SHOW_ROW_HEAD, true));
		meta.setHideGroup4Editing(DomHelper.readAttr(element, MetaConstants.GRID_HIDE_GROUP_4_EDITING, false));
		meta.setPageLoadType(PageLoadType.parse(DomHelper.readAttr(element, MetaConstants.GRID_PAGELOADTYPE, PageLoadType.STR_NONE)));

		// 前台存在全局属性控制,需要三态
		meta.setSortable(DomHelper.readBool(element, MetaConstants.GRID_SORTABLE, null));
		meta.setDefaultFitWidth(DomHelper.readBool(element, MetaConstants.GRID_DEFAULTFITWIDTH, null));
		meta.setShowTotalRowCount(DomHelper.readBool(element, MetaConstants.GRID_SHOWTOTALROWCOUNT, null));

		meta.setEditRowFormKey(DomHelper.readAttr(element, MetaConstants.GRID_EDITROWFORMKEY, ""));
		meta.setSelectMode(SelectionMode.parse(DomHelper.readAttr(element, MetaConstants.SELECTION_MODE, SelectionMode.STR_RANGE)));
		meta.setSerialSeq(DomHelper.readAttr(element, MetaConstants.GRID_SERIALSEQ, false));
		meta.setSerialRowNum(DomHelper.readAttr(element, MetaConstants.GRID_SERIALROWNUM, false));
		meta.setEndEditByNav(DomHelper.readAttr(element, MetaConstants.GRID_ENDEDITBYNAV, false));
		meta.setAddDataRow(DomHelper.readAttr(element, MetaConstants.GRID_ADDDATAROW, false));
		meta.setOption(DomHelper.readAttr(element, MetaConstants.GRID_OPTION, null));
		meta.setDisabledOption(DomHelper.readAttr(element, MetaConstants.GRID_DISABLEOPTION, null));
		meta.setGridDefaultSortField(DomHelper.readAttr(element, MetaConstants.GRID_GRIDSORT, ""));
		meta.setLocate(DomHelper.readBool(element,MetaConstants.GRID_LOCATE, null));
	}

	@Override
	public void save(Document document, Element element, MetaGrid meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.GRID_PAGEROWCOUNT, meta.getPageRowCount(), 50);
		DomHelper.writeAttr(element, MetaConstants.GRID_PAGEINDICATORCOUNT, meta.getPageIndicatorCount(), 5);
		DomHelper.writeAttr(element, MetaConstants.GRID_ROWRANGE, meta.getRowRange(), "");
		DomHelper.writeAttr(element, MetaConstants.GRID_NEW_EMPTY_ROW, meta.getNewEmptyRow(), "true");
		DomHelper.writeAttr(element, MetaConstants.GRID_SHOW_ROW_HEAD, meta.isShowRowHead(), true);
		DomHelper.writeAttr(element, MetaConstants.GRID_HIDE_GROUP_4_EDITING, meta.isHideGroup4Editing(), false);
		DomHelper.writeAttr(element, MetaConstants.GRID_PAGELOADTYPE, PageLoadType.toString(meta.getPageLoadType()), PageLoadType.STR_NONE);

		DomHelper.writeAttr(element, MetaConstants.GRID_SORTABLE, meta.getSortable(), null);
		DomHelper.writeAttr(element, MetaConstants.GRID_DEFAULTFITWIDTH, meta.getDefaultFitWidth(), null);
		DomHelper.writeAttr(element, MetaConstants.GRID_SHOWTOTALROWCOUNT, meta.isShowTotalRowCount(), null);

		DomHelper.writeAttr(element, MetaConstants.GRID_EDITROWFORMKEY, meta.getEditRowFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SELECTION_MODE, SelectionMode.toString(meta.getSelectMode()), SelectionMode.STR_RANGE);
		DomHelper.writeAttr(element, MetaConstants.GRID_SERIALSEQ, meta.isSerialSeq(), false);
		DomHelper.writeAttr(element, MetaConstants.GRID_SERIALROWNUM, meta.isSerialRowNum(), false);
		DomHelper.writeAttr(element, MetaConstants.GRID_ENDEDITBYNAV, meta.isEndEditByNav(), false);
		DomHelper.writeAttr(element, MetaConstants.GRID_ADDDATAROW, meta.getAddDataRow(), false);
		DomHelper.writeAttr(element, MetaConstants.GRID_OPTION, meta.getOption(), null);
		DomHelper.writeAttr(element, MetaConstants.GRID_DISABLEOPTION, meta.getDisabledOption(), null);
		DomHelper.writeAttr(element, MetaConstants.GRID_GRIDSORT, meta.getGridDefaultSortField(), "");
		DomHelper.writeAttr(element, MetaConstants.GRID_LOCATE, meta.getLocate(), null);
	}
}