package com.bokesoft.yes.meta.persist.dom.form.component.control.treeview;

import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaBarCoderPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDatePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaHyperLinkPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaMultiStateButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNoticeBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNumberEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaPriceLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaRelativeTimePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaToggleButtonPropertiesAction;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.treeview.MetaTreeViewColumn;

public class MetaTreeViewColumnAction extends BaseDomAction<MetaTreeViewColumn> {
	private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;
	@SuppressWarnings("unchecked")
	public MetaTreeViewColumnAction() {
		super();
		actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
		Object[][] v = new Object[][] {
				{ ControlType.LABEL, new MetaLabelPropertiesAction() },
				{ ControlType.PRICELABEL, new MetaPriceLabelPropertiesAction() },
				{ ControlType.RELATIVETIME, new MetaRelativeTimePropertiesAction() },
				{ ControlType.CHECKBOX, new MetaCheckBoxPropertiesAction() },
				{ ControlType.HYPERLINK, new MetaHyperLinkPropertiesAction() },
				{ ControlType.BUTTON, new MetaButtonPropertiesAction() },
				{ ControlType.NOTICEBAR, new MetaNoticeBarPropertiesAction() },
				{ ControlType.BARCODER, new MetaBarCoderPropertiesAction() },
				{ ControlType.TOGGLEBUTTON, new MetaToggleButtonPropertiesAction() },
				{ ControlType.MULTISTATEBUTTON, new MetaMultiStateButtonPropertiesAction() },
				{ ControlType.DATEPICKER, new MetaDatePickerPropertiesAction() },
				{ ControlType.DICT, new MetaDictPropertiesAction() },
				{ ControlType.NUMBEREDITOR, new MetaNumberEditorPropertiesAction() },
				{ ControlType.TEXTEDITOR, new MetaTextEditorPropertiesAction() }
		};
		int length = v.length;
		for ( int i = 0; i<length; ++i ) {
			Object[] l = v[i];
			Integer type = (Integer)l[0];
			BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>)l[1];
			actionMap.put(type, action);
		}
	}

	@Override
	public void load(Document document, Element element, MetaTreeViewColumn meta, int runType) {	
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "")));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setDataColumnKey(DomHelper.readAttr(element, MetaConstants.TREEVIEW_DATA_COLUMN_KEY, ""));
		meta.setColumnType(ControlType.parse(DomHelper.readAttr(element, MetaConstants.TREEVIEW_COLUMNTYPE, ControlType.STR_LABEL)));
		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getColumnType());
		if ( action != null ) {
			action.load(document, element, meta.getProperties(), runType);
		}
	}

	@Override
	public void save(Document document, Element element, MetaTreeViewColumn meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DefSize width = meta.getWidth();
		if ( width != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TREEVIEW_DATA_COLUMN_KEY, meta.getDataColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TREEVIEW_COLUMNTYPE, ControlType.toString(meta.getColumnType()), ControlType.STR_LABEL);
		
		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getColumnType());
		if ( action != null ) {
			action.save(document, element, meta.getProperties(), runType);
		}
	}

}
