package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.LabelLineBreakType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;

public class MetaLabelExtPropertiesAction extends DomPropertiesAction<MetaLabelProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaLabelProperties meta, int runType) {
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, null));
		String lineBreakModeStr = DomHelper.readAttr(element, MetaConstants.COMMON_BREAKLINEMODE, null);
		if(lineBreakModeStr != null && !lineBreakModeStr.isEmpty()){
			meta.setLineBreakMode(LabelLineBreakType.parse(lineBreakModeStr));
		}else{
			meta.setLineBreakMode(null);
		}
		String singleLineStr = DomHelper.readAttr(element, MetaConstants.COMMON_SIGNLELINE, null);
		if(singleLineStr != null && !singleLineStr.isEmpty()){
			meta.setSingleLine(Boolean.parseBoolean(singleLineStr));
		}else{
			meta.setSingleLine(null);
		}
		String maxLineStr = DomHelper.readAttr(element, MetaConstants.COMMON_MAXLINES, null);
		if(maxLineStr != null && !maxLineStr.isEmpty()){
			meta.setMaxLines(Integer.parseInt(maxLineStr));
		}else{
			meta.setMaxLines(null);
		}
		meta.setExpandCaption(DomHelper.readAttr(element, MetaConstants.LABEL_EXPANDCAPTION, null));

	}

	@Override
	public void saveImpl(Document document, Element element, MetaLabelProperties meta, int runType) {
		
	}

}
