package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaVideoPlayerProperties;

public class MetaVideoPlayerPropertiesAction extends DomPropertiesAction<MetaVideoPlayerProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaVideoPlayerProperties meta, int runType) {
		meta.setSourceType(
				ImageSourceType.parse(DomHelper.readAttr(element, MetaConstants.VIDEOPLAYER_SOURCETYPE, "Data")));
		meta.setPath(DomHelper.readAttr(element, MetaConstants.VIDEOPLAYER_PATH, ""));
		meta.setUploadProgress(UploadProgressType.parse(
				DomHelper.readAttr(element, MetaConstants.VIDEOPLAYER_UPLOADPROGRESS, UploadProgressType.STR_None)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaVideoPlayerProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.VIDEOPLAYER_PATH, meta.getPath(), "");
		DomHelper.writeAttr(element, MetaConstants.VIDEOPLAYER_SOURCETYPE,
				ImageSourceType.toString(meta.getSourceType()), "Data");
		DomHelper.writeAttr(element, MetaConstants.VIDEOPLAYER_UPLOADPROGRESS,
				UploadProgressType.toString(meta.getUploadProgress()), UploadProgressType.STR_None);
	}
}
