package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberInfoEditorProperties;

public class MetaNumberInfoEditorPropertiesAction extends DomPropertiesAction<MetaNumberInfoEditorProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaNumberInfoEditorProperties meta, int runType) {
		meta.setEditorFormat(DomHelper.readAttr(element, MetaConstants.NUMBERINFOEDITOR_FORMAT, ""));
		meta.setImeOptions(EditorImeOptions.parse(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_IMEOPTIONS, "")));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.NUMBERINFOEDITOR_DISABLEKEYBOARD, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaNumberInfoEditorProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.NUMBERINFOEDITOR_FORMAT, meta.getEditorFormat(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_IMEOPTIONS, EditorImeOptions.toString(meta.getImeOptions()), "");
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.NUMBERINFOEDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard().toString(), "");
		}
	}

}
