package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DictItemKeySourceType;
import com.bokesoft.yigo.common.def.DictLoadType;
import com.bokesoft.yigo.common.def.DictQueryMatchType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictSearchBoxProperties;

public class MetaDictSearchBoxPropertiesAction extends DomPropertiesAction<MetaDictSearchBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element,MetaDictSearchBoxProperties meta, int runType) {
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, ""));		
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEY, ""));
		meta.setDynamic(DomHelper.readAttr(element, MetaConstants.DICT_ISDYNAMIC, false));
		meta.setCompDict(DomHelper.readAttr(element, MetaConstants.DICT_ISCOMPDICT, false));
		meta.setAllowMultiSelection(DomHelper.readAttr(element, MetaConstants.DICT_ALLOWMULTISELECTION, false));
		meta.setRoot(DomHelper.readAttr(element, MetaConstants.DICT_ROOT, ""));
		meta.setRefKey(DomHelper.readAttr(element, MetaConstants.DICT_REFKEY, null));
		meta.setIndependent(DomHelper.readAttr(element, MetaConstants.DICT_INDEPENDENT, false));
		meta.setStateMask(DictStateMask.parse(DomHelper.readAttr(element, MetaConstants.DICT_STATEMASK, DictStateMask.STR_Enable)));
		meta.setItemKeySourceType(DictItemKeySourceType.parse(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEYSOURCETYPE, DictItemKeySourceType.STR_DATAOBJECT)));
		meta.setItemKeySource(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEYSOURCE, ""));
		meta.setIgnoreRights(DomHelper.readAttr(element, MetaConstants.DICT_IGNORERIGHTS, false));
		meta.setEditable(DomHelper.readAttr(element, MetaConstants.DICT_EDITABLE, true));
		meta.setEditType(SelectEditType.parse(DomHelper.readAttr(element, MetaConstants.DICT_EDITTYPE, SelectEditType.STR_SIDESLIP)));
		meta.setLoadType(DictLoadType.parse(DomHelper.readAttr(element, MetaConstants.DICT_LOADTYPE, DictLoadType.STR_R2L)));
		meta.setFormulaText(DomHelper.readAttr(element, MetaConstants.DICT_FORMULATEXT, ""));
		meta.setTextField(DomHelper.readAttr(element, MetaConstants.DICT_TEXTFIELD, ""));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, ""));
		meta.setPromptData(DomHelper.readAttr(element, MetaConstants.DICT_PROMPTDATA, false));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.STEPEDITOR_DISABLEKEYBOARD, null));
		meta.setQueryMatchType(DictQueryMatchType.parse(DomHelper.readAttr(element, MetaConstants.DICT_QUERYMATCHTYPE, DictQueryMatchType.STR_Full)));
	}

	@Override
	public void saveImpl(Document document, Element element,MetaDictSearchBoxProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_ISDYNAMIC, meta.isDynamic(), false);
		DomHelper.writeAttr(element, MetaConstants.DICT_ISCOMPDICT, meta.isCompDict(), false);
		DomHelper.writeAttr(element, MetaConstants.DICT_ALLOWMULTISELECTION, meta.isAllowMultiSelection(), false);
		DomHelper.writeAttr(element, MetaConstants.DICT_ITEMKEY, meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_ROOT, meta.getRoot(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_REFKEY, meta.getRefKey(), null);
		DomHelper.writeAttr(element, MetaConstants.DICT_INDEPENDENT, meta.isIndependent(), false);
		DomHelper.writeAttr(element, MetaConstants.DICT_STATEMASK, DictStateMask.toString(meta.getStateMask()), DictStateMask.STR_Enable);
		DomHelper.writeAttr(element, MetaConstants.DICT_ITEMKEYSOURCETYPE, DictItemKeySourceType.format(meta.getItemKeySourceType()), DictItemKeySourceType.STR_DATAOBJECT);
		DomHelper.writeAttr(element, MetaConstants.DICT_ITEMKEYSOURCE, meta.getItemKeySource(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_IGNORERIGHTS, meta.isIgnoreRights(), false);
		DomHelper.writeAttr(element, MetaConstants.DICT_EDITABLE, meta.isEditable(), true);
		DomHelper.writeAttr(element, MetaConstants.DICT_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_SIDESLIP);
		DomHelper.writeAttr(element, MetaConstants.DICT_LOADTYPE, DictLoadType.format(meta.getLoadType()), DictLoadType.STR_R2L);
		DomHelper.writeAttr(element, MetaConstants.DICT_FORMULATEXT, meta.getFormulaText(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_TEXTFIELD, meta.getTextField(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_PROMPTDATA, meta.isPromptData(), false);
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard().toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.DICT_QUERYMATCHTYPE, DictQueryMatchType.format(meta.getQueryMatchType()), DictQueryMatchType.STR_Full);
	}

}
