package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.ItemAnimType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;

public class MetaListViewExtAction extends MetaComponentExtAction<MetaListView> {
	
	@Override
	public void load(Document document, Element element, MetaListView meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, null));
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PAGEROWCOUNT, -1));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.LISTVIEW_ROWHEIGHT, -1));
		meta.setPageLoadType(PageLoadType.parse(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PAGELOADTYPE, PageLoadType.STR_NONE)));
		meta.setShowHead(DomHelper.readAttr(element, MetaConstants.LISTVIEW_SHOWHEAD, false));
		meta.setDefaultSelectRow(DomHelper.readAttr(element, MetaConstants.LISTVIEW_DEFAULTSELECTROW, -1));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.PROMPTTEXT, ""));
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PROMPTIMAGE, ""));
		meta.setPromptRowCount(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PROMPTROWCOUNT, meta.getDefaultPromptRowCount()));
		meta.setItemAnim(DomHelper.readAttr(element, MetaConstants.LISTVIEW_ITEMANIM, ItemAnimType.FADEIN));
		meta.setLayoutAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, ""));
		meta.setOrientation(OrientationType.parse(
				DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.toString(meta.getDefaultOrientation()))));
	}

	@Override
	public void save(Document document, Element element, MetaListView meta, int runType) {

	}
}
