package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaBarCoderExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaButtonExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaCheckBoxExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaCheckListBoxExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaComboBoxExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaCountDownViewExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaCountUpExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTimeCountDownExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaDatePickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaDictExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaEmptyExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaGIFImageExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaHyperLinkExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaIconExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaImageExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaImageListExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaLabelExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaMonthPickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaNoticeBarExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaNumberEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaNumberInfoEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaPasswordEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaPriceLabelExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaProgressBarExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaProgressIndicatorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaRelativeTimeExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaScoreBarExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaSegmentedControlExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaSliderExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaStepEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaSwitchExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTextAreaExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTextEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTimePickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaUTCDatePickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaVideoPlayerExtPropertiesAction;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;

public class MetaEditViewColumnExtAction extends MetaComponentAction<MetaEditViewColumn> {
	private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;
	@SuppressWarnings("unchecked")
	public MetaEditViewColumnExtAction() {
		super();
		actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
		Object[][] v = new Object[][] {
				{ ControlType.LABEL, new MetaLabelExtPropertiesAction() },
				{ ControlType.PRICELABEL, new MetaPriceLabelExtPropertiesAction() },
				{ ControlType.RELATIVETIME, new MetaRelativeTimeExtPropertiesAction() },
				{ ControlType.TEXTAREA, new MetaTextAreaExtPropertiesAction() },
				{ ControlType.CHECKBOX, new MetaCheckBoxExtPropertiesAction() },
				{ ControlType.HYPERLINK, new MetaHyperLinkExtPropertiesAction() },
				{ ControlType.BUTTON, new MetaButtonExtPropertiesAction() },
				{ ControlType.NOTICEBAR, new MetaNoticeBarExtPropertiesAction() },
				{ ControlType.BARCODER, new MetaBarCoderExtPropertiesAction() },
				{ ControlType.DATEPICKER, new MetaDatePickerExtPropertiesAction() },
				{ ControlType.DICT, new MetaDictExtPropertiesAction() },
				{ ControlType.NUMBEREDITOR, new MetaNumberEditorExtPropertiesAction() },
				{ ControlType.TEXTEDITOR, new MetaTextEditorExtPropertiesAction() },
				{ ControlType.COMBOBOX, new MetaComboBoxExtPropertiesAction() },
				{ ControlType.CHECKLISTBOX, new MetaCheckListBoxExtPropertiesAction() },
				{ ControlType.IMAGE, new MetaImageExtPropertiesAction() },
				{ ControlType.VIDEOPLAYER, new MetaVideoPlayerExtPropertiesAction() },
				{ ControlType.UTCDATEPICKER, new MetaUTCDatePickerExtPropertiesAction() },
				{ ControlType.STEPEDITOR, new MetaStepEditorExtPropertiesAction() },
				{ ControlType.ICON, new MetaIconExtPropertiesAction() },
				{ ControlType.TEXTAREA, new MetaTextAreaExtPropertiesAction() },
				{ ControlType.PASSWORDEDITOR, new MetaPasswordEditorExtPropertiesAction() },
				{ ControlType.NUMBERINFOEDITOR, new MetaNumberInfoEditorExtPropertiesAction() },
				{ ControlType.MONTHPICKER, new MetaMonthPickerExtPropertiesAction() },
				{ ControlType.TIMEPICKER, new MetaTimePickerExtPropertiesAction() },
				
				//  TODO 实现ExtendPropertiesAction
				{ ControlType.IMAGEBUTTON, new MetaButtonExtPropertiesAction() },
				{ ControlType.SCOREBAR, new MetaScoreBarExtPropertiesAction() },
				{ ControlType.SWITCH, new MetaSwitchExtPropertiesAction() },
				{ ControlType.SEGMENTEDCONTROL, new MetaSegmentedControlExtPropertiesAction() },
				{ ControlType.PROGRESSINDICATOR, new MetaProgressIndicatorExtPropertiesAction() },
				{ ControlType.PROGRESSBAR, new MetaProgressBarExtPropertiesAction() },
				{ ControlType.SLIDER, new MetaSliderExtPropertiesAction() },
				{ ControlType.COUNTDOWNVIEW, new MetaCountDownViewExtPropertiesAction() },
				{ ControlType.GIFIMAGE, new MetaGIFImageExtPropertiesAction() },
				{ ControlType.IMAGELIST, new MetaImageListExtPropertiesAction() },
				{ ControlType.EMPTY, new MetaEmptyExtPropertiesAction() },
				{ ControlType.COUNTUP, new MetaCountUpExtPropertiesAction() },
				{ ControlType.TIMECOUNTDOWN, new MetaTimeCountDownExtPropertiesAction() }
		};
		int length = v.length;
		for ( int i = 0; i<length; ++i ) {
			Object[] l = v[i];
			Integer type = (Integer)l[0];
			BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>)l[1];
			actionMap.put(type, action);
		}
	}
	
	@Override
	public void load(Document document, Element element, MetaEditViewColumn meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setColumnType(ControlType.parse(DomHelper.readAttr(element, MetaConstants.EDITVIEW_COLUMNTYPE, ControlType.STR_LABEL)));
		
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.EDITVIEW_COLUMN_DATACOLUMNKEY, null));
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.EDITVIEW_COLUMN_WIDTH, "")));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTVALUE, null));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, null));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
		meta.setSelect(DomHelper.readBool(element, MetaConstants.IS_SELECT, null));
		meta.setSingleSelect(DomHelper.readBool(element, MetaConstants.SINGLE_SELECT, null));
		meta.setWrapText(DomHelper.readBool(element, MetaConstants.EDITVIEW_COLUMN_WRAPTEXT, null));
		meta.setSortable(DomHelper.readBool(element, MetaConstants.SORTABLE, null));
		
		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getColumnType());
		if ( action != null ) {
			action.load(document, element, meta.getProperties(), runType);
		}
	}

	@Override
	public void save(Document document, Element element, MetaEditViewColumn meta, int runType) {

	}
}
