package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;

/**
 * 功能控件关联字段对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaDataBindingExtAction extends BaseDomAction<MetaDataBinding> {
	
	@Override
	public void load(Document document, Element element, MetaDataBinding meta, int runType) {
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, null));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, null));
		meta.setRequired(DomHelper.readBool(element, MetaConstants.DATABINDING_REQUIRED, null));
		meta.setValueChanging(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUECHANGING, null));
		meta.setValueChanged(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUECHANGED, null));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.DATABINDING_DEFAULTVALUE, null));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, null));
		meta.setValueDependency(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUEDEPENDENCY, null));
		meta.setCheckRule(DomHelper.readAttr(element, MetaConstants.DATABINDING_CHECKRULE, null));
		meta.setErrorInfo(DomHelper.readAttr(element, MetaConstants.CHECKRULE_ERRORINFO, null));
		meta.setErrorStringID(DomHelper.readAttr(element, MetaConstants.CHECKRULE_ERRORSTRINGID, null));
		meta.setCheckDependency(DomHelper.readAttr(element, MetaConstants.DATABINDING_CHECKDEPENDENCY, null));
		meta.setRequiredIcon(DomHelper.readAttr(element, MetaConstants.COMMON_REQUIRED_ICON, null));
		meta.setCheckRulePassIcon(DomHelper.readAttr(element, MetaConstants.COMMON_CHECKRULE_PASS_ICON, null));
		meta.setCheckRuleErrorIcon(DomHelper.readAttr(element, MetaConstants.COMMON_CHECKRULE_ERROR_ICON, null));
	}
	
	@Override
	public void save(Document document, Element element, MetaDataBinding meta, int runType) {
	
	}

	
}
