package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaFontPicker;

/**
 * 字体选择对象在保存和载入时的动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaFontPickerAction extends MetaComponentAction<MetaFontPicker> {
	@Override
	public void load(Document document, Element element, MetaFontPicker meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setInitFontName(DomHelper.readAttr(element, MetaConstants.FONTPICKER_INITFONTNAME, "Arial"));
		meta.setInitFontSize(DomHelper.readAttr(element, MetaConstants.FONTPICKER_INITFONTSIZE, 12));
	}

	@Override
	public void save(Document document, Element element, MetaFontPicker meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.FONTPICKER_INITFONTNAME, meta.getInitFontName(), "Arial");
		DomHelper.writeAttr(element, MetaConstants.FONTPICKER_INITFONTSIZE, meta.getInitFontSize(), 12);
	}
}
