package com.bokesoft.yes.meta.persist.dom.form.component.container;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ContainerStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaContainerExtAction extends MetaComponentAction<MetaContainer> {
    @Override
    public void load(Document document, Element element, MetaContainer meta, int runType) {
        super.load(document, element, meta, runType);
        meta.setStyle(ContainerStyle.parse(DomHelper.readAttr(element, MetaConstants.CONTAINER_STYLE, "")));
        meta.setDefaultFormKey(DomHelper.readAttr(element, MetaConstants.CONTAINER_DEFAULT_FORM_KEY, null));
        meta.setFormulaFormKey(DomHelper.readAttr(element, MetaConstants.CONTAINER_FORMULA_FORM_KEY, null));
        meta.setDefault(DomHelper.readBool(element, MetaConstants.CONTAINER_IS_DEFAULT, null));
        meta.setMergeOperation(DomHelper.readBool(element, MetaConstants.CONTAINER_MERGE_OPERATION, null));
        meta.setParameters(DomHelper.readAttr(element, MetaConstants.CONTAINER_PARAMETERS, null));
    }

    @Override
    public void save(Document document, Element element, MetaContainer meta, int runType) {
    }
}